<?php
/**
 * Plugin Name: Vraivex Yoast API
 * Description: Permet d'importer les meta descriptions Yoast SEO via l'API REST (catégories, posts, pages)
 * Version: 1.1.0
 * Author: Vraivex
 */

// Exposer le champ meta Yoast pour les taxonomies dans l'API REST
add_action('init', function() {
    // Catégories de produits WooCommerce
    register_term_meta('product_cat', '_yoast_wpseo_metadesc', [
        'type' => 'string',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ]);
    
    // Tags de produits WooCommerce
    register_term_meta('product_tag', '_yoast_wpseo_metadesc', [
        'type' => 'string',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ]);
    
    // Catégories WordPress
    register_term_meta('category', '_yoast_wpseo_metadesc', [
        'type' => 'string',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ]);
    
    // Tags WordPress
    register_term_meta('post_tag', '_yoast_wpseo_metadesc', [
        'type' => 'string',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ]);
});

// Exposer le champ meta Yoast pour les posts/pages dans l'API REST
add_action('init', function() {
    // Posts (articles de blog)
    register_post_meta('post', '_yoast_wpseo_metadesc', [
        'type' => 'string',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ]);
    
    // Pages
    register_post_meta('page', '_yoast_wpseo_metadesc', [
        'type' => 'string',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ]);
    
    // Produits WooCommerce
    register_post_meta('product', '_yoast_wpseo_metadesc', [
        'type' => 'string',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function() {
            return current_user_can('edit_posts');
        }
    ]);
});

// Synchroniser les termes (catégories/tags) avec Yoast quand le meta est modifié
add_action('updated_term_meta', 'vraivex_sync_term_to_yoast', 10, 4);
add_action('added_term_meta', 'vraivex_sync_term_to_yoast', 10, 4);

function vraivex_sync_term_to_yoast($meta_id, $term_id, $meta_key, $meta_value) {
    if ($meta_key !== '_yoast_wpseo_metadesc') return;
    
    $term = get_term($term_id);
    if (!$term || is_wp_error($term)) return;
    
    // Mettre à jour wpseo_taxonomy_meta (où Yoast stocke les meta des termes)
    $tax_meta = get_option('wpseo_taxonomy_meta', []);
    if (!isset($tax_meta[$term->taxonomy])) $tax_meta[$term->taxonomy] = [];
    if (!isset($tax_meta[$term->taxonomy][$term_id])) $tax_meta[$term->taxonomy][$term_id] = [];
    $tax_meta[$term->taxonomy][$term_id]['wpseo_desc'] = $meta_value;
    update_option('wpseo_taxonomy_meta', $tax_meta);
    
    // Mettre à jour le cache Yoast indexable
    global $wpdb;
    $table = $wpdb->prefix . 'yoast_indexable';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table'") === $table) {
        $wpdb->update($table, ['description' => $meta_value], 
            ['object_id' => $term_id, 'object_type' => 'term'], ['%s'], ['%d', '%s']);
    }
}

// Synchroniser les posts/pages avec Yoast indexable quand le meta est modifié
add_action('updated_post_meta', 'vraivex_sync_post_to_yoast', 10, 4);
add_action('added_post_meta', 'vraivex_sync_post_to_yoast', 10, 4);

function vraivex_sync_post_to_yoast($meta_id, $post_id, $meta_key, $meta_value) {
    if ($meta_key !== '_yoast_wpseo_metadesc') return;
    
    // Mettre à jour le cache Yoast indexable
    global $wpdb;
    $table = $wpdb->prefix . 'yoast_indexable';
    if ($wpdb->get_var("SHOW TABLES LIKE '$table'") === $table) {
        $wpdb->update($table, ['description' => $meta_value], 
            ['object_id' => $post_id, 'object_type' => 'post'], ['%s'], ['%d', '%s']);
    }
}
